<?php

if ($_SERVER['SERVER_ADDR'] === '127.0.0.1' || $_SERVER['SERVER_ADDR'] === '::1') {
    define('LOCALHOST_BYPASS', true);
}

if (defined('LOCALHOST_BYPASS')) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

set_time_limit(0);
ini_set('max_execution_time', 0);

$installer_version = '2.5';
$default = 'Full';

if (extension_loaded('xdebug')) {
    ini_set('xdebug.max_nesting_level', 100000);
}

if (!empty($_GET['target']) && is_string($_GET['target']) && Installer::doInstall($_GET['target'])) {
    exit;
}

header('Content-Type: text/html; charset=utf-8');

class Installer{
    public static $packageInfo = [
        'Full' => [
            'tree' => 'GS.CMS 3.3.24',
            'name' => 'Новая установка',
            'link' => 'https://gs-cms.ru/repo/cms/install/GS.CMS.3.3.24.zip',
            'location' => 'admin/install.php'
        ]
    ];

    public static function items($default=null) {
        $ItemGrid = [];
        foreach(static::$packageInfo as $ver=>$item){
            $ItemGrid[$item['tree']][$ver] = $item;
        }
        $rs = [];
        foreach($ItemGrid as $tree=>$item){
            $rs[] = '<div><header class="text-primary">'.strtoupper($tree);
            foreach($item as $version => $itemInfo){
                $rs[] = sprintf(
                    '</header><label><input type="radio" name="target" value="%s"> <span>%s</span></label><br>',
                    $version,
                    $itemInfo['name']
                );
            }
            $rs[] = '</div>';
        }
		
        if(!$default) {
            return implode("\n", $rs);
        }

        return str_replace(
            sprintf('value="%s"', $default),
            sprintf('value="%s" checked', $default),
            implode("\n", $rs)
        );
    }

    public static function hasProblem() {
        if (!ini_get('allow_url_fopen')) {
            return 'Cannot download the files - url_fopen is not enabled on this server.';
        }
        
        if (!class_exists('ZipArchive')) {
            return 'Cannot extract files - Zip extension is not available.';
        }
        
        $memory_limit = ini_get('memory_limit');
        if ($memory_limit != '-1' && self::convertToBytes($memory_limit) < 128 * 1024 * 1024) {
            return 'Low memory limit detected ('.htmlspecialchars($memory_limit).'). Consider increasing memory_limit to at least 128M.';
        }
        
        if (!defined('LOCALHOST_BYPASS') && !Installer::hasDirPerm()) {
            return 'Cannot download the files - The directory does not have write permission.';
        }
        
        return false;
    }
    
    private static function convertToBytes($value) {
        $value = trim($value);
        $last = strtolower($value[strlen($value)-1]);
        $value = (int)$value;
        switch($last) {
            case 'g': $value *= 1024;
            case 'm': $value *= 1024;
            case 'k': $value *= 1024;
        }
        return $value;
    }

    private static function downloadFile($url, $path) {
        $context = stream_context_create([
            'http' => [
                'timeout' => 30,
                'header' => "User-Agent: GetSimple CMS Installer\r\n"
            ]
        ]);
        
        $rs = file_get_contents($url, false, $context);
        if(!$rs) {
            return false;
        }
        return file_put_contents($path, $rs);
    }

    private static function moveFiles($src, $dest) {
        $path = realpath($src);
        $dest = realpath($dest);
        $objects = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($path),
            RecursiveIteratorIterator::SELF_FIRST
        );
        
        foreach($objects as $name => $object) {
            $startsAt = substr(dirname($name), strlen($path));
            self::mmkDir($dest.$startsAt);
            if ($object->isDir()) {
                self::mmkDir($dest.substr($name, strlen($path)));
            }

            if(is_writable($dest.$startsAt) && $object->isFile()) {
                rename((string)$name, $dest.$startsAt.'/'.basename($name));
            }
        }
    }

    private static function mmkDir($folder, $perm=0777) {
        if(is_dir($folder)) {
            return;
        }
        if (mkdir($folder, $perm, true) || is_dir($folder)) {
            return;
        }
        throw new \RuntimeException(
            sprintf(
                'Directory "%s" was not created', $folder
            )
        );
    }

    public static function doInstall($target_version=null) {
        if (empty($target_version) || !is_scalar($target_version)) {
            return false;
        }
        if (!isset(static::$packageInfo[$target_version])) {
            return false;
        }

        $rowInstall = static::$packageInfo[$target_version];
        $base_dir = str_replace('\\','/',__DIR__);
        $temp_dir = $base_dir.'/_temp_'.bin2hex(random_bytes(8));

        try {
            if (!static::downloadFile($rowInstall['link'], 'fetch.zip')) {
                throw new \RuntimeException('Failed to download the package');
            }

            $zip = new ZipArchive;
            if ($zip->open($base_dir.'/fetch.zip') !== true) {
                throw new \RuntimeException('Failed to open the downloaded package');
            }
            
            if (!$zip->extractTo($temp_dir)) {
                $zip->close();
                throw new \RuntimeException('Failed to extract the package');
            }
            $zip->close();
            unlink($base_dir.'/fetch.zip');

            $dir = '';
            if ($handle = opendir($temp_dir)) {
                while ($name = readdir($handle)) {
                    if ($name === '.' || $name === '..') {
                        continue;
                    }
                    $dir = $name;
                    break;
                }
                closedir($handle);
            }

            if (empty($dir)) {
                throw new \RuntimeException('No files found in the downloaded package');
            }

            static::moveFiles($temp_dir.'/'.$dir, $base_dir.'/');
            static::rmdirs($temp_dir);

            if (file_exists(__FILE__)) {
                unlink(__FILE__);
            }
            
            header('Location: '.$rowInstall['location']);
            return true;
            
        } catch (\Exception $e) {

            if (file_exists($base_dir.'/fetch.zip')) {
                unlink($base_dir.'/fetch.zip');
            }

            if (is_dir($temp_dir)) {
                static::rmdirs($temp_dir);
            }
            
            if (defined('LOCALHOST_BYPASS')) {
                die('Installation failed: '.htmlspecialchars($e->getMessage()).'');
            } else {
                die('Installation failed. Please check server permissions and try again.');
            }
        }
    }

    private static function rmdirs($dir) {
        if (!is_dir($dir)) {
            return;
        }
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object === '.' || $object === '..') {
                continue;
            }
            $path = sprintf('%s/%s', $dir, $object);
            if (is_dir($path) && !is_link($path)) {
                self::rmdirs($path);
            } else {
                unlink($path);
            }
        }
        rmdir($dir);
    }

    private static function hasDirPerm() {
        $test_file = __DIR__.'/installer_test_'.time().'.tmp';
        $test_content = 'test';

        if (file_put_contents($test_file, $test_content) === false) {
            return false;
        }

        if (file_get_contents($test_file) !== $test_content) {
            unlink($test_file);
            return false;
        }

        unlink($test_file);
        return true;
    }
}

?>

<?php

$error = false;

if (version_compare(PHP_VERSION, '7.4') >= 0) {
					$requirement1 = '<div class="alert alert-success">Установленная версия: ' . PHP_VERSION . '</div>';
} else {
					$error        = true;
					$requirement1 = '<div class="alert alert-danger">Установленная версия PHP: ' . PHP_VERSION . '</div>';
}

if (!extension_loaded('curl')) {
					$error = true;
					$requirement4 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement4 = '<div class="alert alert-success">Включен</div>';
}

if (!extension_loaded('gd')) {
					$error = true;
					$requirement9 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement9 = '<div class="alert alert-success">Включен</div>';
}

if (!extension_loaded('zip')) {
					$error = true;
					$requirement10 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement10 = '<div class="alert alert-success">Включен</div>';
}

if (!extension_loaded('SimpleXML')) {
					$error = true;
					$requirement12 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement12 = '<div class="alert alert-success">Включен</div>';
}

if (!extension_loaded('openssl')) {
					$error = true;
					$requirement5 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement5 = '<div class="alert alert-success">Включен</div>';
}

$mod_rewrite = false;
if (function_exists('apache_get_modules')) {
					$mod_rewrite = in_array('mod_rewrite', apache_get_modules());
} else {
					$mod_rewrite = true;
}

if (!$mod_rewrite) {
					$error = true;
					$requirement13 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
} else {
					$requirement13 = '<div class="alert alert-success">Включен</div>';
}
				
$writable = is_writable(__DIR__);
				if (!$writable) {
					$error = true;
					$requirement14 = '<div class="alert alert-danger">Недоступен для записи</div>';
				} else {
					$requirement14 = '<div class="alert alert-success">Доступен для записи</div>';
				}
				
				if (!ini_get('allow_url_fopen')) {
					$error = true;
					$requirement16 = '<div class="alert alert-danger"><b>Выключен!</b><br/>Исправьте ошибку и попробуйте снова.</div>';
				} else {
					$requirement16 = '<div class="alert alert-success">Включен</div>';
				}

			?>

<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8" />
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <title>GS.CMS » Загрузка и установка</title>
      <meta name="title" content="GS.CMS » Загрузка и установка" />
      <meta name="description" content="GS.CMS » Загрузка и установка" />
      <link rel="stylesheet" href="https://gs-cms.ru/repo/cms/install/bootstrap.min.css" />
      <link rel="stylesheet" href="https://gs-cms.ru/repo/cms/install/ud-styles.css" />
   </head>
<body>

<section class="ud-features">
   <div class="container">
      <div class="row">
         <div class="col-lg-12">
            <div class="ud-section-title">
               <h2>GS.CMS &bull; Загрузка и установка</h2>
               <p>
                Перед началом установки, убедитесь что сервер соответствует минимальным требованиям.
               </p>
            </div>
         </div>
      </div>
      <div class="row">

         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">Версия PHP</h3>
                  <p class="ud-feature-desc">
                  Ниминальная: 7.4.x<br/>
                  <?php echo $requirement1; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">cURL PHP Extension</h3>
                  <p class="ud-feature-desc">
                  Требуется для получения обновлений.<br/>
                  <?php echo $requirement4; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">GD PHP Extension</h3>
                  <p class="ud-feature-desc">
                  Требуется для обработки изображений.<br/>
                  <?php echo $requirement9; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">Zip PHP Extension</h3>
                  <p class="ud-feature-desc">
                  Требуется для создания и распаковки ZIP-архивов.<br/>
                  <?php echo $requirement10; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">OpenSSL PHP Extension</h3>
                  <p class="ud-feature-desc">
                  Требуется для HTTPS соединения.<br/>
                  <?php echo $requirement5; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">SimpleXML</h3>
                  <p class="ud-feature-desc">
                  Требуется для обработки XML-файлов.<br/>
                  <?php echo $requirement12; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">Apache Mod Rewrite</h3>
                  <p class="ud-feature-desc">
                  Требуется для формирования URL-адресов.<br/>
                  <?php echo $requirement13; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">Права на папки</h3>
                  <p class="ud-feature-desc">
                  Установить права на запись и чтение файлов и папок.<br/>
                  <?php echo $requirement14; ?>
                  </p>
               </div>
            </div>
         </div>
         <div class="col-xl-3 col-lg-3 col-sm-6">
            <div class="ud-single-feature">
               <div class="ud-feature-content">
                  <h3 class="ud-feature-title">allow_url_fopen</h3>
                  <p class="ud-feature-desc">
                  Требуется для загрузки файлов по URL.<br/>
                  <?php echo $requirement16; ?>
                  </p>
               </div>
            </div>
         </div>
      </div>
   </div>
<!--/section>

<section class="ud-features"-->

<br/>

   <div class="container">
      <div class="row">
         <div class="col-lg-12">

            <?php
            if(!$error && $error == "") {
            ?>

            <div class="ud-section-title">
               <h3>Начало установки</h3>
               <div class="mt20"></div>
               <p>Выберите версию для загрузки</p>
               <div class="mt20"></div>
               <p>
                  <form>
                  <?= Installer::items($default) ?>
                  <?= Installer::hasProblem() ?: '<div class="mt20"></div><button class="ud-main-btn ud-primary-btn">Загрузить</button>' ?>
                  </form>
               </p>
            </div>

            <?php
            } else {
            ?>

            <div class="ud-section-title">
               <div class="alert alert-danger">
               <h3>Найдены ошибки!</h3>
               <div class="mt20"></div>
               <p>Параметры сервера не соответствуют минимальным требованиям.</p>
               <div class="mt20"></div>
               <p>Мы не гарантируем стабильную работу программы с текущими параметрами.</p>
               </div>
            </div>

            <?php
            }
            ?>

         </div>
      </div>
   </div>
</section>
</body>
</html>